/*\
 *  This file is part of morph.
 *  Copyright (C) 2000  Oliver Knill
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

/*---------------------------------------------------------------------------*/
/*  ppmmorph.c                                                            */
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define Pi         3.1415926535897932     
#define TWO_PI_INV 0.1591549430918953   

double mod(double r) { r=r-floor(r); return(r); }

// Definition of the map 
double  f(double g, double x,double y) {return(2*x+g*sin(2*Pi*x)-y);}
double  g(double g, double x,double y) {return(x);}

/* double  f(double g, double x,double y) {return(TWO_PI_INV*g*sin(2*Pi*x*y));}    */
/* double  g(double g, double x,double y) {return(TWO_PI_INV*g*cos(2*Pi*(x-y)));}  */

void morph(char *image, int x_size, int y_size, double lambda){
  int     i, j, p,q;
  double  x,y, new_x, new_y;
  char    *ptr;
  
  for(j = 0; j > -y_size; j--)              // ppmimage = { (i,j) in ZxZ  | 
    for(i = 0 ; i < x_size; i++){           //  0<=i<x_size, -y_size<j<= 0  }

      x  = 1.*i/x_size; 
      y  = 1.-1.*j/y_size;

      new_x = mod(f(lambda,x,y));
      new_y = mod(g(lambda,x,y)); 

      p = (int) rint( x_size*(new_x)   ); 
      q = (int) rint( - y_size*(new_y) );

      if(0 <= p && p < x_size && q > -y_size && q <= 0){
	ptr = image + 3 * ((-q) * x_size + p); 
	fputc(*ptr++,stdout); fputc(*ptr++,stdout); fputc(*ptr,stdout);
      }
      else{ fputc(0,stdout); fputc(0,stdout); fputc(0,stdout); }
    }
}

int main(int argc, char *argv[]){
  int i, x_size, y_size, c_size;
  char buffer[1025], *image, *ptr;
  double lambda;
  FILE *in;

  if(argc != 3){
    fprintf(stderr,"Usage: ppmmorph <lambda> [pnmfile] \n");
    exit(1);
  }

  lambda=atof(argv[1]);
    
  if((in = fopen(argv[2],"rb")) == NULL){
    fprintf(stderr,"Can't open file %s\n", argv[2]);
    exit(1);
  } 

  fgets(buffer,1025,in);
  if(strncmp(buffer,"P6",2)){
    fprintf(stderr,"Unsupported file format (need PPM raw)\n");
    exit(1);
  }
  
  do fgets(buffer,1025,in); while(*buffer == '#');     // get picture dimension
  x_size = atoi(strtok(buffer," "));
  y_size = atoi(strtok(NULL," "));
  fgets(buffer,1025,in);                               // get color map size
  c_size = atoi(buffer);

  if((image = (char *) malloc(3*x_size*y_size*sizeof(char)))==NULL){
    fprintf(stderr,"Memory allocation error while loading picture\n");
    exit(1);
  }
  
  i = 0;
  ptr = image;
  while(!feof(in) && i<3*x_size*y_size){ *ptr++ = fgetc(in); i++;}
  fclose(in);

  if(i<x_size*y_size){ 
     fprintf(stderr,"Premature end of image\n"); exit(1);
  }

  printf("P6\n%i %i\n%i\n", x_size, y_size, c_size);
  morph(image,x_size,y_size,lambda);
  return 0;
}

